﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using System.ComponentModel.Composition; //Export
using MEF_Interfejs;

//EmailSender
using System.Net;
using System.Net.Mail;

namespace MEF_Wtyczka_EmailSender
{
    [Export(typeof(IMessageSender))]
    [ExportMetadata("CzyUzywaSieci",true)]
    public class EmailSender : IMessageSender
    {
        //te parametry powinny byc ustalane przez argumenty konstruktora
        public const bool wysylanieListowEmailAktywne = true; //false gdy testy offline
        public const string loginPocztyWychodzacej = "loginWP";
        public const string hasloPocztyWychodzacej = "hasło";
        public const string adresNadawcy = "login@wp.pl";
        public const string serwerSMTP = "smtp.wp.pl";
        public const int portSMTP = 25;

        static private bool WyslijEmail(string adresEmail, string adresEmailDW, string subject, string body)
        {
            try
            {
                SmtpClient smtp = new SmtpClient(serwerSMTP, portSMTP);
                //smtp.Credentials = CredentialCache.DefaultNetworkCredentials;
                smtp.Credentials = new NetworkCredential(loginPocztyWychodzacej,
                                                         hasloPocztyWychodzacej);
                MailMessage list = new MailMessage(adresNadawcy, adresEmail);
                if (adresEmailDW != null) list.CC.Add(adresEmailDW);
                list.Subject = subject;
                list.IsBodyHtml = true;
                list.Body = body;
                if (wysylanieListowEmailAktywne) smtp.Send(list);
                return true;
            }
            catch (Exception)
            {
                return false;
            }
        }

        public bool Send(string message)
        {
            return WyslijEmail("jacek@fizyka.umk.pl", null, "Test MEF", message);
        }
    }
}
